function [userPerSat]=linkbudget(MAS,MAS_i,powerTr,powerTr_i,cellNumber,freq,GT_dB,...
    GT_dB_i,Ge_dB,Dedge,BER,margin_dB,MS,Rc,K,totBW_downlink,clusterSize,ROF, Ruser,addChannelFactor, ISL, ISL_i, Risl, Nmin, NPmin, NUIF)

                                                if MAS(MAS_i) == 1 % MF-TDMA scheme
                                                power = (powerTr(powerTr_i)/cellNumber);
                                                RfdmaNfdmaCell1 = linkRate(freq,power,GT_dB(GT_dB_i),...
                                                    Ge_dB,Dedge,2,BER,margin_dB,MS,Rc,K);
                                                RfdmaNfdmaCell2 = BWLimit((totBW_downlink/clusterSize),MS,ROF,Rc);
                                                userPerSat = MF_TDMA(min(RfdmaNfdmaCell1,RfdmaNfdmaCell2),Ruser,cellNumber,...
                                                    clusterSize,addChannelFactor,ISL(ISL_i),Risl,Nmin,NPmin);
                                            elseif MAS(MAS_i) == 2 % MF-CDMA scheme
                                                NcEbNo = linkEbNo(freq,(powerTr(powerTr_i)/cellNumber),GT_dB(GT_dB_i),Ge_dB,...
                                                    Dedge,2,Ruser,margin_dB,MS);
                                                userPerSat = MF_CDMA(totBW_downlink,Ruser,BER,NcEbNo,NUIF,MS,cellNumber,...
                                                    addChannelFactor,Rc,K,ISL(ISL_i),Risl,Nmin,NPmin);
                                            else
                                                disp('Only MF-TDMA and MF-CDMA systems are considered.');
                                            end;
                                            
                                            % appendend functions
                                            % function linkRate
% Module that calculates the data rate of a link

% Darren Chang (darrenz@mit.edu)
% Last modified by 8/14/02

function dataRate = linkRate(freq,power,GT_dB,GR_dB,dist,UpDownX,BER,margin,MS,Rc,K)

% freq: [MHz]

freq_GHz = freq/1000;

% Step 1: rx loss b/w transmitter and antenna is picked based on experience

Ll_dB = -1;		% dB

% Step 2: calculate space loss
% dist in m

Lspace_dB = 147.55 - 20*log10(dist*1000) - 20*log10(freq_GHz*1e9);		% dB

% Step 3: estimate atmospheric loss using ITU-R P676-4

La_dB = -0.2;		% temporary, dB
Lpolar_dB = -0.3;	% polarization mismatch loss, dB
Lradom_dB = -1;	% radome loss, dB

% Step 4: estimate system noise (Table 13-10 in SMAD)
if UpDownX == 2				% downlink
   if freq_GHz < 2				% GHz
      Tnoise_dBK = 25.7;	% dB-K
   elseif 2 <= freq_GHz & freq_GHz <= 12
      Tnoise_dBK = 27.4;
   else
      Tnoise_dBK = 28.6;
   end;
elseif UpDownX == 3			% crosslink
   Tnoise_dBK = 32.5;
elseif UpDownX == 1			% uplink
   if freq_GHz < 20
      Tnoise_dBK = 31.1;
   else
      Tnoise_dBK = 32.6;
   end;
else					
   Tnoise_dBK = 0;
end;

% Step 5: find Eb/No
if strcmp(MS,'QPSK')
    EbNo_dB = viterbi(BER,Rc,K);
   %EbNo = (erfinv(1 - 2*Pb)).^2;
   %EbNo_dB = 10*log10(EbNo);
else
   disp('Only QPSK modulation is used.');
end

% Step 6: add implementation loss and margin and calculate total data rate of a sat.
Limp_dB = -1;  % dB

% total loss
Ltot_dB = Ll_dB + Lspace_dB + La_dB + Lpolar_dB + Lradom_dB + Limp_dB; 

dataRate_dB = 10*log10(power) + Ltot_dB + GT_dB + GR_dB + 228.6 - Tnoise_dBK - EbNo_dB - margin;
dataRate = 10^(0.1*dataRate_dB)/1000;    % kbps


% =================
% function BWLimit
% By Darren Chang(darrenz@mit.edu)
% Last modified by 8/13/02

function RfdmaNfdma2 = BWLimit(totBW,MS,ROF,Rc)

% Bt = frequency channel bandwidth
% Bg = guard bandwidth

% assumption for MF-TDMA based on Iridium system:
% Bt/(Bt+Bg) = 0.9712

% code rate Rc will exacerbate the bandwidth limit

% for QPSK, modulation level M = 4
M = 4;

if strcmp(MS,'QPSK')
   RfdmaNfdma2 = totBW*1000*log2(M)/(1+ROF)*0.9712/str2num(Rc);  %[MHz]
else
   disp('Only QPSK modulation is used.');
end


% ====================

% function MF_TDMA
% Darren D. Chang, darrenz@mit.edu
% Last modified: 7/9/02

function userPerSat = MF_TDMA(RfdmaNfdmaCell,Ruser,cellNumber,clusterSize,addChannelFactor,ISL,Risl,Nmin,NPmin)

% FL  - TDMA frame length
% FIL - framing length, data used to setup the frame
% TGL - total guard length

% assumptions for MF-TDMA scheme based on Iridium system:
% FIL = 19.2% FL
% TGL = 4% FL
% (1 - FIL/FL)/(1 + TGL/(FL-FIL)) = 0.77

% Capacity defined by MF-TDMA
userPerSat1 = floor(0.5*cellNumber*RfdmaNfdmaCell*0.77/Ruser*addChannelFactor);

if ISL == 1
    % Capacity defined by ISL
    userPerSat2 = floor(Risl*1000/Ruser);
    % Final capacity is the lower of the two
    userPerSat = min(userPerSat1,userPerSat2);
elseif ISL == 0
    userPerSat = userPerSat1;
end;

% =================================

% function MF_CDMA
% Darren D. Chang, darrenz@mit.edu
% Last modified: 7/15/02

function userPerSat = MF_CDMA(totBW,Ruser,BER,NcEbNo,f,MS,cellNumber,addChannelFactor,Rc,K,ISL,Risl,Nmin,NPmin)
% guard band factor = (total guard band)/(total band)
BGfactor = 0.0247;  % from Globalstar
alpha = 0.5;        % voice activity state of user N
totBW_Hz = totBW*1e6;   % total bandwidth in Hz
Ruser_bps = Ruser*1e3;  % user rate in bps

% assume the CDMA scheme has the same processing gain as Globalstar
% process gain = (carrier bandwidth)/(user datarate) = 1230/9.6 [for Globalstar]
processGain = 1230/9.6;
carrierBW = Ruser_bps*4*processGain;     % [Hz]
T = round(totBW_Hz/(carrierBW*(1 + BGfactor))); % # of carriers
Bsat_TBg=totBW_Hz*(1 - BGfactor);
X = totBW_Hz*(1 - BGfactor)/Ruser_bps/(alpha*(1 + f));

if strcmp(MS,'QPSK')
    EbLtot_dB = viterbi(BER,Rc,K);
    EbLtot = 10^(EbLtot_dB/10);
    LtotEb = 1/EbLtot;
else
   disp('Only QPSK modulation is used.');
end

Nc = floor((T + X*LtotEb)/(1 + X/NcEbNo));

% Capacity defined by MF-CDMA
userPerSat1 = floor(Nc*cellNumber*addChannelFactor);

if ISL == 1
    % Capacity defined by ISL
    userPerSat2 = floor(Risl*1000/Ruser);
    % Final capacity is the lower of the two
    userPerSat = min(userPerSat1,userPerSat2);
elseif ISL == 0
    userPerSat = userPerSat1;
end;


% ================================

% function linkEbNo
% Module that calculates the EbNo of a link

% Darren Chang (darrenz@mit.edu)
% Last modified by 10/29/02

function  EbNo = linkEbNo(freq,power,GT_dB,GR_dB,dist,UpDownX,dataRate,margin_dB,MS)

% dataRate: [Kbps]
% freq: [MHz]
freq_GHz = freq/1000;

% Step 1: rf loss b/w transmitter and antenna is picked based on experience

Ll_dB = -1;		% dB

% Step 2: calculate space loss
% dist in m

Lspace_dB = 147.55 - 20*log10(dist*1000) - 20*log10(freq_GHz*1e9);		% dB

% Step 3: estimate atmospheric loss using ITU-R P676-4

La_dB = -0.2;		% dB
Lpolar_dB = -0.3;	% polarization mismatch loss, dB
Lradom_dB = -1;	% radome loss, dB

% Step 4: estimate system noise. (Table 13-10 in SMAD)
if UpDownX == 2				% downlink
   if freq_GHz < 2				% GHz
      Tnoise_dBK = 25.7;	% dB-K
   elseif 2 <= freq_GHz & freq_GHz <= 12
      Tnoise_dBK = 27.4;
   else
      Tnoise_dBK = 28.6;
   end;
elseif UpDownX == 3			% crosslink
   Tnoise_dBK = 32.5;
elseif UpDownX == 1			% uplink
   if freq_GHz < 20
      Tnoise_dBK = 31.1;
   else
      Tnoise_dBK = 32.6;
   end;
else					
   Tnoise_dBK = 0;
end;

% Step 5: add implementation loss and margin and calculate total data rate of a sat.

Limp_dB = -1;  % dB

% total loss

Ltot_dB = Ll_dB + Lspace_dB + La_dB + Lpolar_dB + Lradom_dB + Limp_dB;

dataRate_dB = 10*log10(dataRate*1000);  %dB(bps)

EbNo_dB = 10*log10(power) + Ltot_dB + GT_dB + GR_dB + 228.6 - Tnoise_dBK - dataRate_dB - margin_dB;
EbNo = 10^(0.1*EbNo_dB);

%=============================

% function viterbi
% Module that calculates Eb/No for
% a convolutional coding - Viterbi decoding
% scheme

% Darren Chang (darrenz@mit.edu)
% Last modified by 8/14/02

% the data in this function are for BPSK or QPSK soft-decision

function EbNo_dB = viterbi(BER,Rc,K)
% find EbNo via interpolation function
if strcmp(Rc,'1/3')
    if K == 3
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [2.6  4.09 5.07 5.95 6.69 7.38 7.97 8.5  9     9.5   9.96 ],BER);
    elseif K == 4
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [2    3.4  4.41 5.34 6    6.66 7.25 7.78 8.23  8.67  9    ],BER);
    elseif K == 5
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [1.45 2.85 3.82 4.64 5.35 5.97 6.55 7.07 7.55  7.96  8.33 ],BER);
    elseif K == 6
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [1.12 2.51 3.45 4.18 4.88 5.49 6    6.5  6.95  7.35  7.66 ],BER);
    elseif K == 7
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [1.09 2.13 3    3.78 4.4  4.99 5.52 6    6.47  6.88  7.21 ],BER);
    elseif K == 8
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [0.87 1.86 2.68 3.36 3.95 4.5  5.03 5.55 5.99  6.41  6.75 ],BER);
    else
        disp('WARNING: no such constraint length value K is available');
        EbNo_dB = 1000;
    end
elseif strcmp(Rc,'1/2')
    if K == 3
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [2.96 4.13 5.10 5.99 6.80 7.54 8.21 8.81 9.34  9.79  10.16],BER);
    elseif K == 4
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [2.65 3.71 4.70 5.55 6.27 6.97 7.60 8.12 8.66  9.11  9.49  ],BER);
    elseif K == 5
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [2.45 3.36 4.22 5.00 5.75 6.36 7.00 7.56 8.05 8.49   8.85 ],BER);
    elseif K == 6
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [2.14 3.15 3.99 4.71 5.36 5.94 6.49 7.00 7.45  7.89  8.25 ],BER);
    elseif K == 7
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [1.73 2.65 3.52 4.22 4.89 5.45 5.94 6.40 6.91  7.32  7.69 ],BER);
    elseif K == 8
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [1.36 2.45 3.24 3.94 4.54 5.10 5.61 6.10 6.57  7.00  7.36  ],BER);
    elseif K == 9
        EbNo_dB=interp1([1e-2 1e-3 1e-4 1e-5 1e-6 1e-7 1e-8 1e-9 1e-10 1e-11 1e-12],...
                        [1.18 2.14 2.97 3.63 4.19 4.72 5.19 5.66 6.12  6.56  6.96 ],BER);
    else
        disp('WARNING: no such constraint length value K is available');
        EbNo_dB = 1000;
    end
elseif strcmp(Rc,'2/3')
    if K == 6
        EbNo_dB=interp1([1e-2 1e-3 1e-5 1e-7],...
                        [2.1  2.9  4.2  4.7 ],BER);
    elseif K == 8
        EbNo_dB=interp1([1e-2 1e-3 1e-5 1e-7],...
                        [2.2  3.1  4.6  5.2 ],BER);
    else
        disp('WARNING: no such constraint length value K is available');
        EbNo_dB = 1000;
    end
elseif strcmp(Rc,'3/4')
    if K == 6
        EbNo_dB=interp1([1e-2 1e-3 1e-5 1e-7],...
                        [1.9  2.6  3.6  3.9 ],BER);
    elseif K == 9
        EbNo_dB=interp1([1e-2 1e-3 1e-5 1e-7],...
                        [1.6  2.6  4.2  4.8 ],BER);
    else
        disp('WARNING: no such constraint length value K is available');
        EbNo_dB = 1000;
    end
else
   disp('WARNING: no such code rate Rc value is available');
   EbNo_dB = 1000;
end
